﻿using System;
using VA.TMP.Integration.VIMT.HealthShare.StateObject;
using VA.TMP.Integration.VIMT.Messages.HealthShare;
using VRM.Integration.Servicebus.Core;

namespace VA.TMP.Integration.VIMT.HealthShare.PipelineSteps.MakeCancel
{
    /// <summary>
    /// Create response step.
    /// </summary>
    public class CreateResponseStep : FilterBase<MakeCancelStateObject>
    {
        /// <summary>
        /// Execute the step.
        /// </summary>
        /// <param name="state">State object.</param>
        public override void Execute(MakeCancelStateObject state)
        {
            try
            {
                state.ResponseMessage = new TmpHealthShareMakeAndCancelAppointmentResponseMessage { ExceptionOccured = false };
            }
            catch (Exception ex)
            {
                throw new Exception(string.Format("HealthShare Make Cancel CreateResponseStep Pipeline Error: {0}", ex.Message), ex.InnerException);
            }
        }
    }
}